import React, {Component} from 'react';
import Select from "../Select/Select";
import {graphql, compose} from "react-apollo";
import { marcaturaQuery } from "../../../../api/queries";
import {Card, CardBody, CardText} from "reactstrap";
import BlinkDot from "../../../Loading/BlinkDot";

class MarcaturaSelect extends Component {

  constructor(props) {
    super(props);
  }

  render() {
    if(this.props.data.loading) {
      return(<Card>
        <CardBody>
          <CardText className="text-info">
            Caricamento in corso{' '}
            <BlinkDot/>
            <BlinkDot/>
            <BlinkDot/>
          </CardText>
        </CardBody>
      </Card>);
    }

    return (
      <Select
        {...this.props}
        options={[
          {label: "Seleziona un\'opzione", value: ''},
          ...this.props.data.tipoMarcaturas.map((option) => ({
            label: option.etichetta,
            value: option.id
          }))
        ]}
      />
    )
  }
}

export default compose(
  graphql(marcaturaQuery),
)(MarcaturaSelect)

MarcaturaSelect.defaultProps = {};

MarcaturaSelect.propTypes = {};
